-- phpMyAdmin SQL Dump
-- version 4.5.1
-- http://www.phpmyadmin.net
--
-- Host: localhost:3306
-- Generation Time: Jan 11, 2017 at 12:58 PM
-- Server version: 10.1.16-MariaDB
-- PHP Version: 5.5.30

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `elmah`
--

DELIMITER $$
--
-- Procedures
--
CREATE DEFINER=`root`@`localhost` PROCEDURE `elmah_GetErrorsXml` (IN `App` VARCHAR(60), IN `PageIndex` INT(10), IN `PageSize` INT(10), OUT `TotalCount` INT(10))  READS SQL DATA
BEGIN
    
    SELECT  count(*) INTO TotalCount
    FROM    `elmah_error`
    WHERE   `Application` = App;

    SET @index = PageIndex * PageSize;
    SET @count = PageSize;
    SET @app = App;
    PREPARE STMT FROM '
    SELECT
        `ErrorId`,
        `Application`,
        `Host`,
        `Type`,
        `Source`,
        `Message`,
        `User`,
        `StatusCode`,
        CONCAT(`TimeUtc`, '' Z'') AS `TimeUtc`
    FROM
        `elmah_error` error
    WHERE
        `Application` = ?
    ORDER BY
        `TimeUtc` DESC,
        `Sequence` DESC
    LIMIT
        ?, ?';
    EXECUTE STMT USING @app, @index, @count;

END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `elmah_GetErrorXml` (IN `Id` CHAR(36), IN `App` VARCHAR(60))  READS SQL DATA
BEGIN
    SELECT  `AllXml`
    FROM    `elmah_error`
    WHERE   `ErrorId` = Id AND `Application` = App;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `elmah_LogError` (IN `ErrorId` CHAR(36), IN `Application` VARCHAR(60), IN `Host` VARCHAR(30), IN `Type` VARCHAR(100), IN `Source` VARCHAR(60), IN `Message` VARCHAR(500), IN `User` VARCHAR(50), IN `AllXml` TEXT, IN `StatusCode` INT(10), IN `TimeUtc` DATETIME)  MODIFIES SQL DATA
BEGIN
    INSERT INTO `elmah_error` (
        `ErrorId`, 
        `Application`, 
        `Host`, 
        `Type`, 
        `Source`, 
        `Message`, 
        `User`, 
        `AllXml`, 
        `StatusCode`, 
        `TimeUtc`
    ) VALUES (
        ErrorId, 
        Application, 
        Host, 
        Type, 
        Source, 
        Message, 
        User, 
        AllXml, 
        StatusCode, 
        TimeUtc
    );
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `elmah_error`
--

CREATE TABLE `elmah_error` (
  `ErrorId` char(36) NOT NULL,
  `Application` varchar(60) NOT NULL,
  `Host` varchar(50) NOT NULL,
  `Type` varchar(100) NOT NULL,
  `Source` varchar(60) NOT NULL,
  `Message` varchar(500) NOT NULL,
  `User` varchar(50) NOT NULL,
  `StatusCode` int(10) NOT NULL,
  `TimeUtc` datetime NOT NULL,
  `Sequence` int(10) NOT NULL,
  `AllXml` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `elmah_error`
--
ALTER TABLE `elmah_error`
  ADD PRIMARY KEY (`Sequence`),
  ADD UNIQUE KEY `IX_ErrorId` (`ErrorId`(8)),
  ADD KEY `IX_ELMAH_Error_App_Time_Seql` (`Application`(10),`TimeUtc`,`Sequence`),
  ADD KEY `IX_ErrorId_App` (`ErrorId`(8),`Application`(10));

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `elmah_error`
--
ALTER TABLE `elmah_error`
  MODIFY `Sequence` int(10) NOT NULL AUTO_INCREMENT;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
